<?php
function renderSitemap($links, $domainZone, $template) {
    $menuLinks = '<ul>';

    foreach ($links as $link) {
        // Пропускаем записи без уровня
        if (!isset($link['Level']) || trim($link['Level']) === '') {
            continue;
        }

        $page = $link['Page'] === '/' ? '/' : '/' . ltrim($link['Page'], '/') . '-' . $domainZone . '/';
        $linkTitle = $link['H1'];
        $menuLinks .= "<li><a href=\"$page\">$linkTitle</a></li>";
    }

    $menuLinks .= '</ul>';

    return str_replace(
        ['%title%', '%description%', '%head%', '%body%', '%menu%', '%domain%'],
        ['Карта сайта', '', '', '<h1>Карта сайта</h1>' . $menuLinks, '', $_SERVER['HTTP_HOST']],
        $template
    );
}
